<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Kod Menü</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js" integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <link rel="stylesheet" href="{{ asset('assets/custom/main.css') }}">
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>

<body>
    <div class="fixed-header">
        <marquee behavior="scroll" direction="left">{{ $ayarlar->where('key', 'KAYAR_YAZI')->first()->value }}</marquee>
    </div>

    <div class="container mt-5 pt-5">
        <div class="text-center my-4">
            <img src="{{ asset('storage/uploads/' . $ayarlar->where('key', 'LOGO')->first()->value) }}" alt="Logo" class="img-fluid" style="max-width: 200px;">
        </div>
        <div class="text-center my-4">
            <a href="https://www.instagram.com/{{ $ayarlar->where('key', 'INSTAGRAM')->first()->value }}" class="btn btn-outline-primary">Instagram</a>
            <a href="{{ $ayarlar->where('key', 'GOOGLE_MAPS')->first()->value }}" class="btn btn-outline-success">Google Maps</a>
        </div>
        <h2 class="text-center my-4 font-weight-bold">Menülerimiz</h2>
        <div class="category-scroll my-2 text-center" id="category-container">
            @foreach($menus as $menu)
            <div class="category-item @if($loop->first) active @endif" onclick="showProducts('{{$menu->name}}')">
                <img src="{{ asset('storage/' . $menu->image) }}" alt="{{$menu->name}}" class="card-img-top">
                <p>{{$menu->name}}</p>
            </div>
            @endforeach

        </div>
        <div class="text-center">
            <button id="toggleViewBtn" class="btn btn-secondary" onclick="toggleView()">Hepsini Göster</button>
        </div>
        <hr>
        <div id="product-container" class="row"></div>
    </div>

    <footer class="text-center mt-5">
      <p class="font-weight-bold">© 2025 <a href="https://www.dijimenu.com.tr">Diji Menü</a> - Tüm hakları saklıdır.</p>
    </footer>

    <!-- Modal -->
    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <img id="modalImage" src="" class="img-fluid" alt="">
                    <h4 id="modalTitle" class="text-center mt-2"></h4>
                    <p id="modalDescription" class="text-center"></p>
                </div>
            </div>
        </div>
    </div>


    <a href="#" id="scrollToTopBtn" class="scroll-to-top"><i class="fa fa-arrow-up"></i></a>

    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="{{ asset('assets/custom/script.js') }}"></script>
</body>

</html>
